package gov.va.vamf.scheduling.direct.domain.eligibility;

import com.agilex.healthcare.directscheduling.domain.DirectSchedulingFacilityProvider;
import com.agilex.healthcare.veteranappointment.domain.Namespace;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "elibility-clinical-service", namespace = Namespace.DirectScheduling)
@XmlAccessorType(value = XmlAccessType.NONE)
@JsonIgnoreProperties({"requestSupported", "directSchedulingSupported"})
public class ClinicalServiceEligibility {
    @XmlElement
    private ClinicalServiceIdentifier clinicalServiceIdentifier;

    @JsonProperty
    private boolean isDirectSchedulingSupported;

    @JsonProperty
    private boolean isRequestSupported;

    @XmlElement
    private EligibilityClinics directSchedulingClinics;

    @XmlElement
    private DirectSchedulingFacilityProvider pactTeam;

    @XmlElement
    private Integer submittedRequestLimit;

    @XmlElement
    private String expressCareEndTime;

    public ClinicalServiceIdentifier getClinicalServiceIdentifier() {
        return clinicalServiceIdentifier;
    }

    public void setClinicalServiceIdentifier(ClinicalServiceIdentifier clinicalServiceIdentifier) {
        this.clinicalServiceIdentifier = clinicalServiceIdentifier;
    }

    public boolean isDirectSchedulingSupported() {
        return isDirectSchedulingSupported;
    }

    public void setDirectSchedulingSupported(boolean directSchedulingSupported) {
        isDirectSchedulingSupported = directSchedulingSupported;
    }

    public boolean isRequestSupported() {
        return isRequestSupported;
    }

    public void setRequestSupported(boolean requestSupported) {
        isRequestSupported = requestSupported;
    }

    public EligibilityClinics getDirectSchedulingClinics() {
        return directSchedulingClinics;
    }

    public void setDirectSchedulingClinics(EligibilityClinics directSchedulingClinics) {
        this.directSchedulingClinics = directSchedulingClinics;
    }

    public DirectSchedulingFacilityProvider getPactTeam() {
        return pactTeam;
    }

    public void setPactTeam(DirectSchedulingFacilityProvider pactTeam) {
        this.pactTeam = pactTeam;
    }

    public Integer getSubmittedRequestLimit() {
        return submittedRequestLimit;
    }

    public void setSubmittedRequestLimit(Integer submittedRequestLimit) {
        this.submittedRequestLimit = submittedRequestLimit;
    }

    public String getExpressCareEndTime() {
        return expressCareEndTime;
    }

    public void setExpressCareEndTime(String expressCareEndTime) {
        this.expressCareEndTime = expressCareEndTime;
    }
}
